/* $Id: ole_docfile.h,v 1.2 1997/09/04 02:34:47 dps Exp dps $ */
/* This code handles the internals of docfiles */

#ifdef __cplusplus
#ifndef __OLE_DOCFILE_H__
#define __OLE_DOCFILE_H__

#include <ole/ole.h>
#include <ole/ole_dir.h>
#include <ole/ole_common.h>

class ole_docfile: public ole
{
private:

/* Cleanest way I can think of doing this... any better ideas? */
#include <ole/ole_docfile_map.h>

    /* The big map is a small extension of map */
    class big_map: public map
    {
    private:
	/* Types */
	typedef struct
	{
	    const unsigned char *hdr;
	    int offset;
	} boot_data;
	istream *in;

	/* Get #sectors in map */
	inline int map_sectors(void *d)
	{
	    boot_data *h=(boot_data *) d;
	    return get_long(h->hdr+HDR_BIG_MAP_N);
	}
	int ole_docfile::big_map::get_sect(void *, unsigned char *);

    public:
	inline big_map(const unsigned char *h, istream *i): map(SECTOR_SIZE);
	{
	    boot_data *dp;

	    dp=new(boot_data);		 // Allocate map loading data
	    dp->hdr=h;			 // header block
	    dp->offset=HDR_BIG_MAP_D;	 // Offset to first header block no.
	    i=in;			 // Data source
	    this->load_map((void *) dp); // Load the map (inlined)
	    free(dp);			 // Free map loading data
	}

	inline int load_sector(ole_sect s, unsigned char *buff)
	{
	    in->seekg(s*SECTOR_SIZE+SECTOR_SIZE);
	    in->read(buff, SECTOR_SIZE);
	    return (in->fail()) ? 0 : 1;
	}
    };

	    

    typedef enum { EMPTY, FULL } ole_fpps_used;
    typedef struct
    {
	ole_id dotdot;
	ole_fpps_used used;
    } ole_fpps_entry;

    /* Constructor tools */
    int __small_grab_sector(unsigned char *d, void *p);
    int load_small_map(const unsigned char *);
    int __big_grab_sector(unsigned char *d, void *p);
    int load_big_map(const unsigned char *);

    /* load a sector */
    inline void load_sector(long sect, unsigned char *buff)
    {
	in->seekg(sect*SECTOR_SIZE+SECTOR_SIZE, ios::beg);
	in->read(buff, SECTOR_SIZE);
	if (in->fail())
	{
	    cerr<<"ole::load_sector failed (fatal)\n";
	    fatal(4);
	}
    }


    long find_offset(const struct map *, off_t, long);

    /* file information map builder */
    void __make_fpps_map(olefile *);
    void __recurse_id(ole_id);
    void make_fpps_map(void);

    /* inline efficency hack */
    inline void recurse_id(ole_id id)
    {
	if (id==INVALID_PPS)
	    return;
	this->__recurse_id(id);
    }

    /* methods */
    int unpack_file(const unsigned char *, olefile *);
    off_t map_offset(const olefile *, off_t);

public:
    /* inline stuff */
    inline olefile *root_dir(void)
    {
	return this->getfile(file_info.d.sect);	// Currenlty allways 0
    }

    /* public methods */
    ole_docfile(istream *);
    olefile *getfile(ole_id id);
    __ole_vsect map_sector(const olefile *, off_t);
};

#endif /* __OLE_DOCFILE_H__ */
#endif /* __cplusplus */



