/* $Id: filetime_to_time.c,v 1.7 1997/09/12 00:18:21 dps Exp $ */
/* filetime to Un*x time_t and mapping functions. The extra precision
 * filetime's afford seems pointless IMHO because I am skeptical that
 * anyone's clock is within 100ns of the correct time, unless their
 * computer is fitted with an atomic clock (no computer I have seen so
 * far features this hardware).
 */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <ole/ole_filetime.h>
#include "config.h"

#if SIZEOF_LONG == 8
#define llong long
#elif SIZEOF_LONG_LONG == 8
#define llong long long
#endif

#if SIZEOF_INT == 4
#define u32 unsigned int
#elif SIZEOF_LONG == 4
#define u32 unsigned long
#else
#undef u32
#endif

/* Sanity check */
#if !defined(llong) && !defined(u32)
#error FATAL ERROR: No 32 or 64 bit type found
#endif

#if !defined(llong) || defined(TEST)
/* This code is provided for the sanity of those without (64 bit)
 * long long's which are big win here. It is also bigger and slower
 * than long long's code (the compiler can not spot what we are doing
 * and we can not tell it without long long's or asm.
 */

/* Classic shift method. How does algorithm D, Knuth v.2 p. 257 compare? */
time_t filetime_to_time(const struct filetime *d)
{
    u32 alow, ahigh, thigh, tlow, r;
    int i;

    /* FIXME: should "preshift" 24 bits here because 10,000,000 is a 24 bit
     * number. */
    tlow=d->low;
    thigh=d->high;
    ahigh=0;
    alow=0;
    r=0;

    tlow++;
    for (i=0; i<64; i++)
    {
	r=(r<<1)+(thigh>>31);
	thigh=(thigh<<1)+(tlow>>31);
	tlow=tlow<<1;
	ahigh=(ahigh<<1)+(alow>>31);
	alow=alow<<1;
	if (r>=10000000)
	{
	    r-=10000000;
	    alow++;
	}
    }

    /* od with obase=16 says that 89*24*60*60+369*365*24*60*60=0x2b6109100
     * Just do the subtraction and test the result....
     */
    if (alow<0xb6109100)
	ahigh--;		       // Carry as used in subtraction
    alow-=0xb6109100;
    ahigh-=0x2;
    if (ahigh>>31)		       // -ve test
	fputs("Warning: *Time travel* occured! document date is before 1970\n",
	      stderr);
    if (ahigh>0)
	fputs("Warning: The time_t's have wrapped...expect the wrong date\n",
	      stderr);
    return (time_t) alow;
}
#endif /* no llong or TEST */

#if defined(llong)
#if defined(TEST)
#define filetime_to_time __mk_timet
#endif /* TEST */

/* long long leverage makes it a doddle */
time_t filetime_to_time(const struct filetime *ftime)
{
    unsigned llong temp;
    
    temp=((llong) (ftime->high))<<32 | (ftime->low);
    temp=temp/10000000;
    /* This number is still too big, but only just! */
    temp-=((llong) 89)*24*3600+((llong) 369)*365*24*3600;
    if (temp & (((llong) 1)<<63))
	fputs("Warning: *Time travel* occured! document date is before 1970\n",
	      stderr);
    if (temp & ((llong) 0x7fffffff)<<32)
	fputs("Warning: the time_t's have wrapped, expect the wrong date\n",
	      stderr);

    return (time_t) temp;	// Should be OK until 2018
}

#endif /* llong */
