/* $Id: open_file.cc,v 1.1 1997/09/03 00:10:32 dps Exp $ */
/* Open a file */

#include <errno.h>
#include <ole/ole.h>
#include <ole/ole_dir.h>

ole_base::olefile *ole::open(const char *name)
{
    olefile *scan;
    char comp[32];
    int i;

    if (name[0]=='/')
    {
	scan=this->root_dir();
	name++;
    }
    else
    {
	scan=&cwd;
    }
    
    while(*name)
    {
	/* Grab the filename */
	for (i=0; i<32; i++)
	{
	    if (*(name+i)=='/')
	    {
		name++;		// Skip / when scanning next component
		break;
	    }
	    if (*(name+i)=='\0')
		break;
	    comp[i]=*(name+i);
	}
	/* Check for an invalid name */
	if (i==32)
	{
	    errno=ENOENT;	// Error: name not found
	    return NULL;	// Impossible names not found
	}
	comp[i]='\0';		// Terminate sting
	name+=i;		// Advance name

	if (i==0)
	    continue;		// Handle // and terminal /

	ole_dir d(scan);

	if ((scan=d.scan_dir(comp))==NULL) // Do standard lookup.
	{
	    errno=ENOENT;	// Error: file does not exist
	    return NULL;	// Name not found
	}
	d.closedir();
    }
    return scan;
};
	



