#ifndef __WINE_WINUSER16_H
#define __WINE_WINUSER16_H

#include "winbase.h"
#include "winuser.h"

#pragma pack(1)

  /* SetWindowPlacement() struct */
typedef struct
{
    UINT16   length;
    UINT16   flags;
    UINT16   showCmd;
    POINT16  ptMinPosition WINE_PACKED;
    POINT16  ptMaxPosition WINE_PACKED;
    RECT16   rcNormalPosition WINE_PACKED;
} WINDOWPLACEMENT16, *LPWINDOWPLACEMENT16;

/****** Window classes ******/

typedef struct
{
    UINT16      style;
    WNDPROC16   lpfnWndProc WINE_PACKED;
    INT16       cbClsExtra;
    INT16       cbWndExtra;
    HANDLE16    hInstance;
    HICON16     hIcon;
    HCURSOR16   hCursor;
    HBRUSH16    hbrBackground;
    SEGPTR      lpszMenuName WINE_PACKED;
    SEGPTR      lpszClassName WINE_PACKED;
} WNDCLASS16, *LPWNDCLASS16;

typedef struct
{
    UINT32      cbSize;
    UINT32      style;
    WNDPROC16   lpfnWndProc;
    INT16       cbClsExtra;
    INT16       cbWndExtra;
    HANDLE16    hInstance;
    HICON16     hIcon;
    HCURSOR16   hCursor;
    HBRUSH16    hbrBackground;
    SEGPTR      lpszMenuName;
    SEGPTR      lpszClassName;
    HICON16     hIconSm;
} WNDCLASSEX16, *LPWNDCLASSEX16;

typedef struct
{
    HWND16    hwnd;
    UINT16    message;
    WPARAM16  wParam;
    LPARAM    lParam WINE_PACKED;
    DWORD     time WINE_PACKED;
    POINT16   pt WINE_PACKED;
} MSG16, *LPMSG16;

/* Cursors / Icons */

typedef struct
{
    POINT16 ptHotSpot;
    WORD    nWidth;
    WORD    nHeight;
    WORD    nWidthBytes;
    BYTE    bPlanes;
    BYTE    bBitsPerPixel;
} CURSORICONINFO;

typedef struct
{
    BYTE   fVirt;
    WORD   key;
    WORD   cmd;
} ACCEL16, *LPACCEL16;

/* FIXME: not sure this one is correct */
typedef struct {
  UINT16    cbSize;
  UINT16    fMask;
  UINT16    fType;
  UINT16    fState;
  UINT16    wID;
  HMENU16   hSubMenu;
  HBITMAP16 hbmpChecked;
  HBITMAP16 hbmpUnchecked;
  DWORD     dwItemData;
  LPSTR     dwTypeData;
  UINT16    cch;
} MENUITEMINFO16, *LPMENUITEMINFO16;

/* DrawState defines ... */
typedef BOOL16 (CALLBACK *DRAWSTATEPROC16)(HDC16,LPARAM,WPARAM16,INT16,INT16);

/* Listbox messages */
#define LB_ADDSTRING16           (WM_USER+1)
#define LB_INSERTSTRING16        (WM_USER+2)
#define LB_DELETESTRING16        (WM_USER+3)
#define LB_SELITEMRANGEEX16      (WM_USER+4)
#define LB_RESETCONTENT16        (WM_USER+5)
#define LB_SETSEL16              (WM_USER+6)
#define LB_SETCURSEL16           (WM_USER+7)
#define LB_GETSEL16              (WM_USER+8)
#define LB_GETCURSEL16           (WM_USER+9)
#define LB_GETTEXT16             (WM_USER+10)
#define LB_GETTEXTLEN16          (WM_USER+11)
#define LB_GETCOUNT16            (WM_USER+12)
#define LB_SELECTSTRING16        (WM_USER+13)
#define LB_DIR16                 (WM_USER+14)
#define LB_GETTOPINDEX16         (WM_USER+15)
#define LB_FINDSTRING16          (WM_USER+16)
#define LB_GETSELCOUNT16         (WM_USER+17)
#define LB_GETSELITEMS16         (WM_USER+18)
#define LB_SETTABSTOPS16         (WM_USER+19)
#define LB_GETHORIZONTALEXTENT16 (WM_USER+20)
#define LB_SETHORIZONTALEXTENT16 (WM_USER+21)
#define LB_SETCOLUMNWIDTH16      (WM_USER+22)
#define LB_ADDFILE16             (WM_USER+23)
#define LB_SETTOPINDEX16         (WM_USER+24)
#define LB_GETITEMRECT16         (WM_USER+25)
#define LB_GETITEMDATA16         (WM_USER+26)
#define LB_SETITEMDATA16         (WM_USER+27)
#define LB_SELITEMRANGE16        (WM_USER+28)
#define LB_SETANCHORINDEX16      (WM_USER+29)
#define LB_GETANCHORINDEX16      (WM_USER+30)
#define LB_SETCARETINDEX16       (WM_USER+31)
#define LB_GETCARETINDEX16       (WM_USER+32)
#define LB_SETITEMHEIGHT16       (WM_USER+33)
#define LB_GETITEMHEIGHT16       (WM_USER+34)
#define LB_FINDSTRINGEXACT16     (WM_USER+35)
#define LB_CARETON16             (WM_USER+36)
#define LB_CARETOFF16            (WM_USER+37)

/* Combo box messages */
#define CB_GETEDITSEL16            (WM_USER+0)
#define CB_LIMITTEXT16             (WM_USER+1)
#define CB_SETEDITSEL16            (WM_USER+2)
#define CB_ADDSTRING16             (WM_USER+3)
#define CB_DELETESTRING16          (WM_USER+4)
#define CB_DIR16                   (WM_USER+5)
#define CB_GETCOUNT16              (WM_USER+6)
#define CB_GETCURSEL16             (WM_USER+7)
#define CB_GETLBTEXT16             (WM_USER+8)
#define CB_GETLBTEXTLEN16          (WM_USER+9)
#define CB_INSERTSTRING16          (WM_USER+10)
#define CB_RESETCONTENT16          (WM_USER+11)
#define CB_FINDSTRING16            (WM_USER+12)
#define CB_SELECTSTRING16          (WM_USER+13)
#define CB_SETCURSEL16             (WM_USER+14)
#define CB_SHOWDROPDOWN16          (WM_USER+15)
#define CB_GETITEMDATA16           (WM_USER+16)
#define CB_SETITEMDATA16           (WM_USER+17)
#define CB_GETDROPPEDCONTROLRECT16 (WM_USER+18)
#define CB_SETITEMHEIGHT16         (WM_USER+19)
#define CB_GETITEMHEIGHT16         (WM_USER+20)
#define CB_SETEXTENDEDUI16         (WM_USER+21)
#define CB_GETEXTENDEDUI16         (WM_USER+22)
#define CB_GETDROPPEDSTATE16       (WM_USER+23)
#define CB_FINDSTRINGEXACT16       (WM_USER+24)

typedef struct /* not sure if the 16bit version is correct */
{
    UINT32	cbSize;
    HWND16	hwndOwner;
    HINSTANCE16	hInstance;
    SEGPTR	lpszText;
    SEGPTR	lpszCaption;
    DWORD	dwStyle;
    SEGPTR	lpszIcon;
    DWORD	dwContextHelpId;
    MSGBOXCALLBACK	lpfnMsgBoxCallback;
    DWORD	dwLanguageId;
} MSGBOXPARAMS16,*LPMSGBOXPARAMS16;


#pragma pack(4)

VOID        WINAPI CalcChildScroll(HWND16,WORD);
VOID        WINAPI CascadeChildWindows(HWND16,WORD);
INT16       WINAPI CloseComm(INT16);
HGLOBAL16   WINAPI CreateCursorIconIndirect(HINSTANCE16,CURSORICONINFO*,
                                            LPCVOID,LPCVOID);
BOOL16      WINAPI DCHook(HDC16,WORD,DWORD,LPARAM);
BOOL16      WINAPI DlgDirSelect(HWND16,LPSTR,INT16);
BOOL16      WINAPI DlgDirSelectComboBox(HWND16,LPSTR,INT16);
DWORD       WINAPI DumpIcon(SEGPTR,WORD*,SEGPTR*,SEGPTR*);
BOOL16      WINAPI EnableCommNotification(INT16,HWND16,INT16,INT16);
BOOL16      WINAPI EnableHardwareInput(BOOL16);
VOID        WINAPI FillWindow(HWND16,HWND16,HDC16,HBRUSH16);
INT16       WINAPI FlushComm(INT16,INT16);
UINT16      WINAPI GetCommEventMask(INT16,UINT16);
HBRUSH16    WINAPI GetControlBrush(HWND16,HDC16,UINT16);
HWND16      WINAPI GetDesktopHwnd(void);
WORD        WINAPI GetIconID(HGLOBAL16,DWORD);
FARPROC16   WINAPI GetMouseEventProc(void);
INT16       WINAPI InitApp(HINSTANCE16);
BOOL16      WINAPI IsUserIdle(void);
HGLOBAL16   WINAPI LoadCursorIconHandler(HGLOBAL16,HMODULE16,HRSRC16);
HGLOBAL16   WINAPI LoadDIBCursorHandler(HGLOBAL16,HMODULE16,HRSRC16);
HGLOBAL16   WINAPI LoadDIBIconHandler(HGLOBAL16,HMODULE16,HRSRC16);
HICON16     WINAPI LoadIconHandler(HGLOBAL16,BOOL16);
HMENU16     WINAPI LookupMenuHandle(HMENU16,INT16);
INT16       WINAPI OpenComm(LPCSTR,UINT16,UINT16);
VOID        WINAPI PaintRect(HWND16,HWND16,HDC16,HBRUSH16,const RECT16*);
INT16       WINAPI ReadComm(INT16,LPSTR,INT16);
SEGPTR      WINAPI SetCommEventMask(INT16,UINT16);
BOOL16      WINAPI SetDeskPattern(void);
VOID        WINAPI TileChildWindows(HWND16,WORD);
INT16       WINAPI UngetCommChar(INT16,CHAR);
VOID        WINAPI UserYield(void);
INT16       WINAPI WriteComm(INT16,LPSTR,INT16);
BOOL16      WINAPI AdjustWindowRect16(LPRECT16,DWORD,BOOL16);
BOOL16      WINAPI AdjustWindowRectEx16(LPRECT16,DWORD,BOOL16,DWORD);
SEGPTR      WINAPI AnsiLower16(SEGPTR);
UINT16      WINAPI AnsiLowerBuff16(LPSTR,UINT16);
SEGPTR      WINAPI AnsiNext16(SEGPTR);
SEGPTR      WINAPI AnsiPrev16(SEGPTR,SEGPTR);
SEGPTR      WINAPI AnsiUpper16(SEGPTR);
UINT16      WINAPI AnsiUpperBuff16(LPSTR,UINT16);
BOOL16      WINAPI AnyPopup16(void);
BOOL16      WINAPI AppendMenu16(HMENU16,UINT16,UINT16,SEGPTR);
UINT16      WINAPI ArrangeIconicWindows16(HWND16);
HDWP16      WINAPI BeginDeferWindowPos16(INT16);
HDC16       WINAPI BeginPaint16(HWND16,LPPAINTSTRUCT16);
BOOL16      WINAPI BringWindowToTop16(HWND16);
BOOL16      WINAPI CallMsgFilter16(SEGPTR,INT16);
LRESULT     WINAPI CallNextHookEx16(HHOOK,INT16,WPARAM16,LPARAM);
LRESULT     WINAPI CallWindowProc16(WNDPROC16,HWND16,UINT16,WPARAM16,LPARAM);
BOOL16      WINAPI ChangeClipboardChain16(HWND16,HWND16);
BOOL16      WINAPI ChangeMenu16(HMENU16,UINT16,SEGPTR,UINT16,UINT16);
BOOL16      WINAPI CheckDlgButton16(HWND16,INT16,UINT16);
BOOL16      WINAPI CheckMenuItem16(HMENU16,UINT16,UINT16);
BOOL16      WINAPI CheckRadioButton16(HWND16,UINT16,UINT16,UINT16);
HWND16      WINAPI ChildWindowFromPoint16(HWND16,POINT16);
HWND16      WINAPI ChildWindowFromPointEx16(HWND16,POINT16,UINT16);
INT16       WINAPI ClearCommBreak16(INT16);
VOID        WINAPI ClientToScreen16(HWND16,LPPOINT16);
BOOL16      WINAPI ClipCursor16(const RECT16*);
BOOL16      WINAPI CloseClipboard16(void);
BOOL16      WINAPI CloseWindow16(HWND16);
HCURSOR16   WINAPI CopyCursor16(HINSTANCE16,HCURSOR16);
HICON16     WINAPI CopyIcon16(HINSTANCE16,HICON16);
BOOL16      WINAPI CopyRect16(RECT16*,const RECT16*);
INT16       WINAPI CountClipboardFormats16(void);
VOID        WINAPI CreateCaret16(HWND16,HBITMAP16,INT16,INT16);
HCURSOR16   WINAPI CreateCursor16(HINSTANCE16,INT16,INT16,INT16,INT16,LPCVOID,LPCVOID);
HWND16      WINAPI CreateDialog16(HINSTANCE16,SEGPTR,HWND16,DLGPROC16);
HWND16      WINAPI CreateDialogIndirect16(HINSTANCE16,LPCVOID,HWND16,DLGPROC16);
HWND16      WINAPI CreateDialogIndirectParam16(HINSTANCE16,LPCVOID,HWND16,
                                               DLGPROC16,LPARAM);
HWND16      WINAPI CreateDialogParam16(HINSTANCE16,SEGPTR,HWND16,DLGPROC16,LPARAM);
HICON16     WINAPI CreateIcon16(HINSTANCE16,INT16,INT16,BYTE,BYTE,LPCVOID,LPCVOID);
HICON16     WINAPI CreateIconFromResourceEx16(LPBYTE,UINT16,BOOL16,DWORD,INT16,INT16,UINT16);
HMENU16     WINAPI CreateMenu16(void);
HMENU16     WINAPI CreatePopupMenu16(void);
HWND16      WINAPI CreateWindow16(LPCSTR,LPCSTR,DWORD,INT16,INT16,INT16,INT16,
                                  HWND16,HMENU16,HINSTANCE16,LPVOID);
HWND16      WINAPI CreateWindowEx16(DWORD,LPCSTR,LPCSTR,DWORD,INT16,INT16,
                                INT16,INT16,HWND16,HMENU16,HINSTANCE16,LPVOID);
LRESULT     WINAPI DefDlgProc16(HWND16,UINT16,WPARAM16,LPARAM);
HDWP16      WINAPI DeferWindowPos16(HDWP16,HWND16,HWND16,INT16,INT16,INT16,INT16,UINT16);
LRESULT     WINAPI DefFrameProc16(HWND16,HWND16,UINT16,WPARAM16,LPARAM);
LRESULT     WINAPI DefHookProc16(INT16,WPARAM16,LPARAM,HHOOK*);
LRESULT     WINAPI DefMDIChildProc16(HWND16,UINT16,WPARAM16,LPARAM);
LRESULT     WINAPI DefWindowProc16(HWND16,UINT16,WPARAM16,LPARAM);
BOOL16      WINAPI DeleteMenu16(HMENU16,UINT16,UINT16);
VOID        WINAPI DestroyCaret16(void);
BOOL16      WINAPI DestroyCursor16(HCURSOR16);
BOOL16      WINAPI DestroyIcon16(HICON16);
BOOL16      WINAPI DestroyMenu16(HMENU16);
BOOL16      WINAPI DestroyWindow16(HWND16);
INT16       WINAPI DialogBox16(HINSTANCE16,SEGPTR,HWND16,DLGPROC16);
INT16       WINAPI DialogBoxIndirect16(HINSTANCE16,HANDLE16,HWND16,DLGPROC16);
INT16       WINAPI DialogBoxIndirectParam16(HINSTANCE16,HANDLE16,HWND16,DLGPROC16,LPARAM);
INT16       WINAPI DialogBoxParam16(HINSTANCE16,SEGPTR,HWND16,DLGPROC16,LPARAM);
LONG        WINAPI DispatchMessage16(const MSG16*);
INT16       WINAPI DlgDirList16(HWND16,LPSTR,INT16,INT16,UINT16);
INT16       WINAPI DlgDirListComboBox16(HWND16,LPSTR,INT16,INT16,UINT16);
BOOL16      WINAPI DlgDirSelectComboBoxEx16(HWND16,LPSTR,INT16,INT16);
BOOL32      WINAPI DlgDirSelectComboBoxEx32A(HWND32,LPSTR,INT32,INT32);
BOOL32      WINAPI DlgDirSelectComboBoxEx32W(HWND32,LPWSTR,INT32,INT32);
BOOL16      WINAPI DlgDirSelectEx16(HWND16,LPSTR,INT16,INT16);
BOOL16      WINAPI DragDetect16(HWND16,POINT16);
DWORD       WINAPI DragObject16(HWND16,HWND16,UINT16,HANDLE16,WORD,HCURSOR16);
BOOL16      WINAPI DrawCaption16(HWND16,HDC16,const RECT16*,UINT16);
BOOL16      WINAPI DrawCaptionTemp16(HWND16,HDC16, const RECT16*,HFONT16,HICON16,LPCSTR,UINT16);
BOOL16      WINAPI DrawEdge16(HDC16,LPRECT16,UINT16,UINT16);
void        WINAPI DrawFocusRect16(HDC16,const RECT16*);
BOOL16      WINAPI DrawFrameControl16(HDC16,LPRECT16,UINT16,UINT16);
BOOL16      WINAPI DrawIcon16(HDC16,INT16,INT16,HICON16);
BOOL16      WINAPI DrawIconEx16(HDC16,INT16,INT16,HICON16,INT16,INT16,
				UINT16,HBRUSH16,UINT16);
VOID        WINAPI DrawMenuBar16(HWND16);
INT16       WINAPI DrawText16(HDC16,LPCSTR,INT16,LPRECT16,UINT16);
BOOL16      WINAPI EmptyClipboard16(void);
UINT16      WINAPI EnableMenuItem16(HMENU16,UINT16,UINT16);
BOOL16      WINAPI EnableScrollBar16(HWND16,INT16,UINT16);
BOOL16      WINAPI EnableWindow16(HWND16,BOOL16);
BOOL16      WINAPI EndDeferWindowPos16(HDWP16);
BOOL16      WINAPI EndDialog16(HWND16,INT16);
BOOL16      WINAPI EndPaint16(HWND16,const PAINTSTRUCT16*);
UINT16      WINAPI EnumClipboardFormats16(UINT16);
BOOL16      WINAPI EqualRect16(const RECT16*,const RECT16*);
LONG        WINAPI EscapeCommFunction16(UINT16,UINT16);
INT16       WINAPI ExcludeUpdateRgn16(HDC16,HWND16);
BOOL16      WINAPI ExitWindows16(DWORD,UINT16);
INT16       WINAPI FillRect16(HDC16,const RECT16*,HBRUSH16);
HWND16      WINAPI FindWindow16(SEGPTR,LPCSTR);
HWND16      WINAPI FindWindowEx16(HWND16,HWND16,SEGPTR,LPCSTR);
BOOL16      WINAPI FlashWindow16(HWND16,BOOL16);
INT16       WINAPI FrameRect16(HDC16,const RECT16*,HBRUSH16);
HWND16      WINAPI GetActiveWindow16(void);
WORD        WINAPI GetAsyncKeyState16(INT16);
HWND16      WINAPI GetCapture16(void);
UINT16      WINAPI GetCaretBlinkTime16(void);
VOID        WINAPI GetCaretPos16(LPPOINT16);
BOOL16      WINAPI GetClassInfo16(HINSTANCE16,SEGPTR,WNDCLASS16 *);
BOOL16      WINAPI GetClassInfoEx16(HINSTANCE16,SEGPTR,WNDCLASSEX16 *);
LONG        WINAPI GetClassLong16(HWND16,INT16);
INT16       WINAPI GetClassName16(HWND16,LPSTR,INT16);
WORD        WINAPI GetClassWord16(HWND16,INT16);
void        WINAPI GetClientRect16(HWND16,LPRECT16);
HANDLE16    WINAPI GetClipboardData16(UINT16);
INT16       WINAPI GetClipboardFormatName16(UINT16,LPSTR,INT16);
HWND16      WINAPI GetClipboardOwner16(void);
HWND16      WINAPI GetClipboardViewer16(void);
void        WINAPI GetClipCursor16(LPRECT16);
DWORD       WINAPI GetCurrentTime16(void);
HCURSOR16   WINAPI GetCursor16(void);
void        WINAPI GetCursorPos16(LPPOINT16);
HDC16       WINAPI GetDC16(HWND16);
HDC16       WINAPI GetDCEx16(HWND16,HRGN16,DWORD);
HWND16      WINAPI GetDesktopWindow16(void);
INT16       WINAPI GetDlgCtrlID16(HWND16);
HWND16      WINAPI GetDlgItem16(HWND16,INT16);
UINT16      WINAPI GetDlgItemInt16(HWND16,INT16,BOOL16*,BOOL16);
INT16       WINAPI GetDlgItemText16(HWND16,INT16,SEGPTR,UINT16);
UINT16      WINAPI GetDoubleClickTime16(void);
HWND16      WINAPI GetFocus16(void);
HWND16      WINAPI GetForegroundWindow16(void);
BOOL16      WINAPI GetInputState16(void);
UINT16      WINAPI GetInternalWindowPos16(HWND16,LPRECT16,LPPOINT16);
INT16       WINAPI GetKeyboardLayoutName16(LPSTR);
INT16       WINAPI GetKeyState16(INT16);
HWND16      WINAPI GetLastActivePopup16(HWND16);
HMENU16     WINAPI GetMenu16(HWND16);
INT16       WINAPI GetMenuItemCount16(HMENU16);
UINT16      WINAPI GetMenuItemID16(HMENU16,INT16);
BOOL16      WINAPI GetMenuItemRect16(HWND16,HMENU16,UINT16,LPRECT16);
UINT16      WINAPI GetMenuState16(HMENU16,UINT16,UINT16);
INT16       WINAPI GetMenuString16(HMENU16,UINT16,LPSTR,INT16,UINT16);
BOOL16      WINAPI GetMessage16(SEGPTR,HWND16,UINT16,UINT16);
HWND16      WINAPI GetNextDlgGroupItem16(HWND16,HWND16,BOOL16);
HWND16      WINAPI GetNextDlgTabItem16(HWND16,HWND16,BOOL16);
HWND16      WINAPI GetNextWindow16(HWND16,WORD);
HWND16      WINAPI GetOpenClipboardWindow16(void);
HWND16      WINAPI GetParent16(HWND16);
INT16       WINAPI GetPriorityClipboardFormat16(UINT16*,INT16);
HANDLE16    WINAPI GetProp16(HWND16,LPCSTR);
DWORD       WINAPI GetQueueStatus16(UINT16);
BOOL16      WINAPI GetScrollInfo16(HWND16,INT16,LPSCROLLINFO);
INT16       WINAPI GetScrollPos16(HWND16,INT16);
BOOL16      WINAPI GetScrollRange16(HWND16,INT16,LPINT16,LPINT16);
HWND16      WINAPI GetShellWindow16(void);
HMENU16     WINAPI GetSubMenu16(HMENU16,INT16);
COLORREF    WINAPI GetSysColor16(INT16);
HBRUSH16    WINAPI GetSysColorBrush16(INT16);
HWND16      WINAPI GetSysModalWindow16(void);
HMENU16     WINAPI GetSystemMenu16(HWND16,BOOL16);
INT16       WINAPI GetSystemMetrics16(INT16);
DWORD       WINAPI GetTabbedTextExtent16(HDC16,LPCSTR,INT16,INT16,const INT16*);
HWND16      WINAPI GetTopWindow16(HWND16);
BOOL16      WINAPI GetUpdateRect16(HWND16,LPRECT16,BOOL16);
INT16       WINAPI GetUpdateRgn16(HWND16,HRGN16,BOOL16);
HWND16      WINAPI GetWindow16(HWND16,WORD);
HDC16       WINAPI GetWindowDC16(HWND16);
LONG        WINAPI GetWindowLong16(HWND16,INT16);
BOOL16      WINAPI GetWindowPlacement16(HWND16,LPWINDOWPLACEMENT16);
void        WINAPI GetWindowRect16(HWND16,LPRECT16);
HTASK16     WINAPI GetWindowTask16(HWND16);
INT16       WINAPI GetWindowText16(HWND16,SEGPTR,INT16);
INT16       WINAPI GetWindowTextLength16(HWND16);
WORD        WINAPI GetWindowWord16(HWND16,INT16);
ATOM        WINAPI GlobalAddAtom16(SEGPTR);
ATOM        WINAPI GlobalFindAtom16(SEGPTR);
UINT16      WINAPI GlobalGetAtomName16(ATOM,LPSTR,INT16);
VOID        WINAPI HideCaret16(HWND16);
BOOL16      WINAPI HiliteMenuItem16(HWND16,HMENU16,UINT16,UINT16);
void        WINAPI InflateRect16(LPRECT16,INT16,INT16);
BOOL16      WINAPI InSendMessage16(void);
BOOL16      WINAPI InsertMenu16(HMENU16,UINT16,UINT16,UINT16,SEGPTR);
BOOL16      WINAPI InsertMenuItem16(HMENU16,UINT16,BOOL16,const MENUITEMINFO16*);
BOOL16      WINAPI IntersectRect16(LPRECT16,const RECT16*,const RECT16*);
void        WINAPI InvalidateRect16(HWND16,const RECT16*,BOOL16);
void        WINAPI InvalidateRgn16(HWND16,HRGN16,BOOL16);
void        WINAPI InvertRect16(HDC16,const RECT16*);
BOOL16      WINAPI IsCharAlpha16(CHAR);
BOOL16      WINAPI IsCharAlphaNumeric16(CHAR);
BOOL16      WINAPI IsCharLower16(CHAR);
BOOL16      WINAPI IsCharUpper16(CHAR);
BOOL16      WINAPI IsChild16(HWND16,HWND16);
BOOL16      WINAPI IsClipboardFormatAvailable16(UINT16);
UINT16      WINAPI IsDlgButtonChecked16(HWND16,UINT16);
BOOL16      WINAPI IsIconic16(HWND16);
BOOL16      WINAPI IsMenu16(HMENU16);
BOOL16      WINAPI IsRectEmpty16(const RECT16*);
BOOL16      WINAPI IsWindowEnabled16(HWND16);
BOOL16      WINAPI IsWindowVisible16(HWND16);
BOOL16      WINAPI IsZoomed16(HWND16);
BOOL16      WINAPI KillSystemTimer16(HWND16,UINT16);
BOOL16      WINAPI KillTimer16(HWND16,UINT16);
HBITMAP16   WINAPI LoadBitmap16(HANDLE16,SEGPTR);
HCURSOR16   WINAPI LoadCursor16(HINSTANCE16,SEGPTR);
HICON16     WINAPI LoadIcon16(HINSTANCE16,SEGPTR);
HANDLE16    WINAPI LoadImage16(HINSTANCE16,LPCSTR,UINT16,INT16,INT16,UINT16);
HMENU16     WINAPI LoadMenu16(HINSTANCE16,SEGPTR);
HMENU16     WINAPI LoadMenuIndirect16(LPCVOID);
INT16       WINAPI LoadString16(HINSTANCE16,UINT16,LPSTR,INT16);
BOOL16      WINAPI LockWindowUpdate16(HWND16);
INT16       WINAPI LookupIconIdFromDirectoryEx16(LPBYTE,BOOL16,INT16,INT16,UINT16);
void        WINAPI MapDialogRect16(HWND16,LPRECT16);
void        WINAPI MapWindowPoints16(HWND16,HWND16,LPPOINT16,UINT16);
VOID        WINAPI MessageBeep16(UINT16);
INT16       WINAPI MessageBox16(HWND16,LPCSTR,LPCSTR,UINT16);
INT16       WINAPI MessageBoxIndirect16(LPMSGBOXPARAMS16);
BOOL16      WINAPI ModifyMenu16(HMENU16,UINT16,UINT16,UINT16,SEGPTR);
BOOL16      WINAPI MoveWindow16(HWND16,INT16,INT16,INT16,INT16,BOOL16);
void        WINAPI OffsetRect16(LPRECT16,INT16,INT16);
BOOL16      WINAPI OpenClipboard16(HWND16);
BOOL16      WINAPI OpenIcon16(HWND16);
BOOL16      WINAPI PeekMessage16(LPMSG16,HWND16,UINT16,UINT16,UINT16);
BOOL16      WINAPI PostAppMessage16(HTASK16,UINT16,WPARAM16,LPARAM);
BOOL16      WINAPI PostMessage16(HWND16,UINT16,WPARAM16,LPARAM);
void        WINAPI PostQuitMessage16(INT16);
BOOL16      WINAPI PtInRect16(const RECT16*,POINT16);
BOOL16      WINAPI RedrawWindow16(HWND16,const RECT16*,HRGN16,UINT16);
ATOM        WINAPI RegisterClass16(const WNDCLASS16*);
ATOM        WINAPI RegisterClassEx16(const WNDCLASSEX16*);
UINT16      WINAPI RegisterClipboardFormat16(LPCSTR);
WORD        WINAPI RegisterWindowMessage16(SEGPTR);
INT16       WINAPI ReleaseDC16(HWND16,HDC16);
BOOL16      WINAPI RemoveMenu16(HMENU16,UINT16,UINT16);
HANDLE16    WINAPI RemoveProp16(HWND16,LPCSTR);
VOID        WINAPI ReplyMessage16(LRESULT);
void        WINAPI ScreenToClient16(HWND16,LPPOINT16);
VOID        WINAPI ScrollChildren16(HWND16,UINT16,WPARAM16,LPARAM);
BOOL16      WINAPI ScrollDC16(HDC16,INT16,INT16,const RECT16*,const RECT16*,
                      HRGN16,LPRECT16);
void        WINAPI ScrollWindow16(HWND16,INT16,INT16,const RECT16*,const RECT16*);
INT16       WINAPI ScrollWindowEx16(HWND16,INT16,INT16,const RECT16*,
                                    const RECT16*,HRGN16,LPRECT16,UINT16);
LRESULT     WINAPI SendDlgItemMessage16(HWND16,INT16,UINT16,WPARAM16,LPARAM);
LRESULT     WINAPI SendMessage16(HWND16,UINT16,WPARAM16,LPARAM);
HWND16      WINAPI SetActiveWindow16(HWND16);
HWND16      WINAPI SetCapture16(HWND16);
VOID        WINAPI SetCaretBlinkTime16(UINT16);
VOID        WINAPI SetCaretPos16(INT16,INT16);
LONG        WINAPI SetClassLong16(HWND16,INT16,LONG);
WORD        WINAPI SetClassWord16(HWND16,INT16,WORD);
HANDLE16    WINAPI SetClipboardData16(UINT16,HANDLE16);
HWND16      WINAPI SetClipboardViewer16(HWND16);
INT16       WINAPI SetCommBreak16(INT16);
HCURSOR16   WINAPI SetCursor16(HCURSOR16);
void        WINAPI SetCursorPos16(INT16,INT16);
BOOL16      WINAPI SetDeskWallPaper16(LPCSTR);
void        WINAPI SetDlgItemInt16(HWND16,INT16,UINT16,BOOL16);
void        WINAPI SetDlgItemText16(HWND16,INT16,SEGPTR);
VOID        WINAPI SetDoubleClickTime16(UINT16);
HWND16      WINAPI SetFocus16(HWND16);
BOOL16      WINAPI SetForegroundWindow16(HWND16);
void        WINAPI SetInternalWindowPos16(HWND16,UINT16,LPRECT16,LPPOINT16);
BOOL16      WINAPI SetMenu16(HWND16,HMENU16);
BOOL16      WINAPI SetMenuContextHelpId16(HMENU16,DWORD);
BOOL16      WINAPI SetMenuItemBitmaps16(HMENU16,UINT16,UINT16,HBITMAP16,HBITMAP16);
BOOL16      WINAPI SetMessageQueue16(INT16);
HWND16      WINAPI SetParent16(HWND16,HWND16);
BOOL16      WINAPI SetProp16(HWND16,LPCSTR,HANDLE16);
void        WINAPI SetRect16(LPRECT16,INT16,INT16,INT16,INT16);
void        WINAPI SetRectEmpty16(LPRECT16);
INT16       WINAPI SetScrollInfo16(HWND16,INT16,const SCROLLINFO*,BOOL16);
INT16       WINAPI SetScrollPos16(HWND16,INT16,INT16,BOOL16);
void        WINAPI SetScrollRange16(HWND16,INT16,INT16,INT16,BOOL16);
VOID        WINAPI SetSysColors16(INT16,const INT16*,const COLORREF*);
HWND16      WINAPI SetSysModalWindow16(HWND16);
BOOL16      WINAPI SetSystemMenu16(HWND16,HMENU16);
UINT16      WINAPI SetSystemTimer16(HWND16,UINT16,UINT16,TIMERPROC16);
UINT16      WINAPI SetTimer16(HWND16,UINT16,UINT16,TIMERPROC16);
LONG        WINAPI SetWindowLong16(HWND16,INT16,LONG);
BOOL16      WINAPI SetWindowPlacement16(HWND16,const WINDOWPLACEMENT16*);
BOOL16      WINAPI SetWindowPos16(HWND16,HWND16,INT16,INT16,INT16,INT16,WORD);
INT16       WINAPI SetWindowRgn16(HWND16,HRGN16,BOOL16);
BOOL16      WINAPI SetWindowText16(HWND16,SEGPTR);
WORD        WINAPI SetWindowWord16(HWND16,INT16,WORD);
VOID        WINAPI ShowCaret16(HWND16);
INT16       WINAPI ShowCursor16(BOOL16);
void        WINAPI ShowScrollBar16(HWND16,INT16,BOOL16);
VOID        WINAPI ShowOwnedPopups16(HWND16,BOOL16);
BOOL16      WINAPI ShowWindow16(HWND16,INT16);
BOOL16      WINAPI SubtractRect16(LPRECT16,const RECT16*,const RECT16*);
BOOL16      WINAPI SwapMouseButton16(BOOL16);
VOID        WINAPI SwitchToThisWindow16(HWND16,BOOL16);
BOOL16      WINAPI SystemParametersInfo16(UINT16,UINT16,LPVOID,UINT16);
LONG        WINAPI TabbedTextOut16(HDC16,INT16,INT16,LPCSTR,INT16,INT16,const INT16*,INT16);
BOOL16      WINAPI TrackPopupMenu16(HMENU16,UINT16,INT16,INT16,INT16,HWND16,const RECT16*);
INT16       WINAPI TranslateAccelerator16(HWND16,HACCEL16,LPMSG16);
BOOL16      WINAPI TranslateMDISysAccel16(HWND16,LPMSG16);
BOOL16      WINAPI TranslateMessage16(const MSG16*);
INT16       WINAPI TransmitCommChar16(INT16,CHAR);
BOOL16      WINAPI UnionRect16(LPRECT16,const RECT16*,const RECT16*);
BOOL16      WINAPI UnregisterClass16(SEGPTR,HINSTANCE16);
VOID        WINAPI UpdateWindow16(HWND16);
VOID        WINAPI ValidateRect16(HWND16,const RECT16*);
VOID        WINAPI ValidateRgn16(HWND16,HRGN16);
HWND16      WINAPI WindowFromDC16(HDC16);
HWND16      WINAPI WindowFromPoint16(POINT16);
BOOL16      WINAPI WinHelp16(HWND16,LPCSTR,UINT16,DWORD);
UINT16      WINAPI WNetAddConnection16(LPCSTR,LPCSTR,LPCSTR);
INT16       WINAPI wvsprintf16(LPSTR,LPCSTR,LPCVOID);
BOOL16      WINAPI DrawState16A(HDC16,HBRUSH16,DRAWSTATEPROC16,LPARAM,WPARAM16,INT16,INT16,INT16,INT16,UINT16);
BOOL16      WINAPI IsDialogMessage16(HWND16,LPMSG16);
INT16       WINAPI GetCommError(INT16,LPCOMSTAT);
BOOL16      WINAPI BuildCommDCB16(LPCSTR,LPDCB16);
INT16       WINAPI GetCommState16(INT16,LPDCB16);
INT16       WINAPI SetCommState16(LPDCB16);


#endif /* __WINE_WINUSER16_H */
