/*
 * $Id: decode11.h,v 1.1 1998/07/24 11:59:13 marc Exp $
 *
 * Prototypes for functions implemented in decode11.c
 *
 * (c) Copyright Marc Vertes, 1998
 *
 */

#ifndef _DECODE11_H_
#define _DECODE11_H_

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* decode11.c */
struct QueueEntry *NewQEntry P_((long SequenceNumber, int Request));
void InitReplyQ P_((void));
void FlushReplyQ P_((FD fd));
void DumpReplyQ P_((FD fd));
void SequencedReplyExpected P_((FD fd, long SequenceNumber, int RequestType));
short CheckReplyTable P_((FD fd, int SequenceNumber));
void ReplyExpected P_((FD fd, int Request));
void KeepLastReplyExpected P_((void));
void DecodeRequest P_((FD fd, unsigned char *buf, long n));
int GrabTimeoutProc P_((TimerID timer, char *message));
void ProcessGrab P_((FD fd, unsigned char *buf, long n));
void DecodeReply P_((FD fd, unsigned char *buf, long n));
void DecodeError P_((FD fd, unsigned char *buf, long n));
void DecodeEvent P_((FD fd, unsigned char *buf, long n));
short MonitorEvent P_((FD fd, unsigned char *buf, long n));

#undef P_

#endif /* _DECODE11_H_ */
