.TH XLAB 1 "28 FEB 1997" "X Version 11"
.SH NAME
xlab - X Window System Script Recording and Playback
.SH SYNOPSIS
.B xlab
[ options ] ...
.SH DESCRIPTION
.I xlab
is a program which sits between an X client and an X server, 
monitors the events flowing from the server to the client,
and records events in a script file. The script file name
for recording is specified using the -r option.
.I xlab 
is useful as part of a regression test
system, as it can automate the playing of
fixed sequences of operations into an 
application program based on X.
.I xlab
can play back events from a script 
file (specified using the -p option) to a client.   
.PP
.I xlab 
can detect application-program failures during playback.
To do so, it detects the failure of windows to 
appear as necessary for playback, and
reports errors when windows do not appear within one second
of when they are expected.  A failure of a window to appear is
symptomatic of several classes of application failures, including
failure of a popup to appear and an application crash.
.PP
\fIxlab\fP functions as a protocol interposition process.  It 
attaches to the X server as if it were a client, and a client attaches
to \fIxlab\fP as if it were an X server.  This allows \fIxlab\fP 
to be used for testing standard unmodified client application programs.
.PP
By adjusting the host and/or display number, clients can be made to
attach to \fIxlab\fP instead of the X server.
.PP
	server <-----> xlab <-----> client(s)
.PP
All bytes from the server are sent to \fIxlab\fP which sends them on to
the client.
All bytes from the client are sent to \fIxlab\fP which passes them on
to the server.
\fIxlab\fP is transparent to both the server and the client.
.SH OPTIONS
.PP
.TP 10
.B \-r<script-file-name>
Requests the recording of a session and 
defines the script file to be written during
recording.
.PP
.TP 10
.B \-p<script-file-name>
Requests the playback of a session and 
defines the script file to be played back.  
The beginning of playback is deferred until the client program
attaches.
.PP
.TP 10
.B \-t<time-contraction-percent>
Specifies the percent time contraction to be used
during playback.  -d50 plays back a session at 50% speed,
and -d200 plays it back at double speed.  Changing playback
speeds may foul up the client's detection of double clicks.
The default time contraction is 100 percent (1:1 playback:record).
.PP
.TP 10
.B \-c<double-click-time>
Specifies the double-click-time in milliseconds.  During playback when
time is contracted or expanded, ButtonPress events with short delays
from the previous event are handled specially so that they do not get
misrecognized by the client.
.PP
.TP 10
.B \-w<wait-before-playback>
Specifies the number of seconds to wait between the time
the client attaches and the first event is played back.  
This allows complex clients to complete drawing before
playback begins.  The default is five seconds.
.PP
.TP 10
.B \-d<display>
Defines the display number.
The display number is added to the input and output port to give the
actual ports which are used by \fIxlab\fP.
.PP
.TP 10
.B \-h<host>
Specifies the hostname on which \fIxlab\fP should look for its X server.
.PP
.PP
.TP 10
.B \-h
Prints a help message.
.PP
.TP 10
.B \-o<output-port>
Determines the port that \fIxlab\fP will use to connect to the server
(default is 0).   For example, if \fIxlab\fP were run with the
options "-hlaser -o0" it would connect to the DISPLAY named "laser:0".
In the normal case it is not necessary to specify \-h or \-o options:
\fIxlab\fP connects, via TCP, to the local host's zeroth display.
.PP
.TP 10
.B \-i<input-port>
Specify the port that \fIxlab\fP will use to take requests from clients
(default is 1).  For example, if \fIxlab\fP were
running on the host named "hobie," 
and the option \-i3 were specified, 
clients for recording or playback would attach to the
DISPLAY named "hobie:3".  Normally, it is not necessary to
specify the \-i option, and clients should be made to connect
via TCP to "localhost:1".
.PP
.TP 10
.B \-q
Quiet output mode.  Gives only the names of requests, replies, errors, and 
events, but does not indicate contents.
.PP
.TP 10
.B \-v<print-level>
Determines the level of verbosity which \fIxlab\fP will provide.
The print-level can be 0 (same as quiet mode), 1, 2, 3, 4.
The larger numbers give more and more output.
For example, a successful setup returns a string which is the name of the
vendor of the X server.
At level 1, the explicit field giving the length of the string is
suppressed since it can be inferred from the string.
At level 2 and above the length is explicitly printed.
.PP
.TP 10
.B \-G<timeout>
Determines the grab timeout.  If any active grab (server,
pointer, or keyboard) originating from the program under
test lasts longer than this time (default 30 seconds) the
xlab program terminates, releasing the grab.  This feature
is handy for use in debugging situations in which grabs deadlock the
server.
.SH COMMANDS
\fIxlab\fP has a command interpreter, which allows to read commands at any
time from the keyboard, a pipe (for GUI interaction) or a file (for complete
automation).
.PP
.TP 5
\fIexit\fP
Terminates the program. If some clients are still connected on xlab, they
will be terminated as well.
.PP
.TP 5
\fIrecord filename\fP
Starts recording user input xevents (keyboard and mouse) in the specified 
filename (same as -r option). 
.PP
.TP 5
\fIreplay filename\fP
Starts replaying events from the specified filename (same as -p option).
.PP
.TP 5
\fIstop record\fP
Stop the current recording. 
.TP 5
\fIstop replay\fP
Stop the current replay. 
.SH OPERATION
When running with \fIxlab\fP, three processes are involved, potentially
all on different machines:
.PP
.TP 5
\fIX server\fP
The X server will run on machine (or host) "A", display "B".
("A" is a machine name; "B" is a display number).
.PP
.TP 5
\fIxlab    \fP
\fIxlab\fP must be told where the X server is (what machine and
what display), and, in addition, the \fIport-number\fP on which to listen
for X clients.
The options for \fIxlab\fP are "-h<Xserver-host>" and "-d<display-number>".
In this example, -hA and -dB.
Typically the \fIdisplay-number\fP is not given.
\fIxlab\fP will not try to  connect to the server until the client
connects to \fIxlab\fP.
.PP
.TP 5
\fIX client\fP
The client should connect to \fIxlab\fP rather than to the server.
To avoid changing the code for the client, \fIxlab\fP listens on
the same port as the server for connecting clients.
If the server and \fIxlab\fP are on different machines, this works well.
However, if the server and \fIxlab\fP are on the same machine, this 
creates a port conflict.
To resolve this conflict, \fIxlab\fP can be given a different
input or output port number, as necessary, to avoid the port that
the server is listening to.
The client must connect to this offset port number.
The input port for \fIxlab\fP is set by \fI-i<port-number>\fP;
the output port is set by \fI-o<port-number>.\fP
The default input port is 1; the default output port is 0.
These ports are offset by the X11 base (6000) and the display number.
The client attaches to \fIxlab\fP by changing its display number by the
port offset.
.SH EXAMPLES
.LP
.B "xlab -hbagel -r/tmp/record"
.PP
The X server would be expected to be found 
on "bagel", display 0 (the default).
\fIxlab\fP and the client would both be running on "cleo".
The client program would think it was connecting to an X server on 
"cleo:1".  This X server is actually \fIxlab\fP, which would
record events and pass through requests and events to the real
X server running on "bagel:0".
.PP
  server (bagel:0) <---> xlab -hbagel <---> client -d cleo:1
.PP
As it runs, \fIxlab\fP records input events for the client
to the file /tmp/record.
.LP
.B "xlab -p/tmp/record"
.PP
The X server would be expected to be found 
on the local host, display 0 (the default).
\fIxlab\fP and the client would be running on the same local host.
The client would connect to "localhost:1", the \fIxlab\fP 
program, which in turn would connect to the real X server on
"localhost:0".
.PP
  server (localhost:0) <---> xlab  <---> client -display localhost:1
.PP
As it runs, \fIxlab\fP plays back pre-recorded events for the client
from the file /tmp/record.  If all is well, the recorded session
should be reproduced.
.SH LIMITATIONS
The X Version 11 is the only protocol recognized.
.PP
The error-detection scheme on playback is extremely limited. At this time
xlab can be confused if the client behaves differently at the replay
(window id matching scheme), but may be fixed soon.
.PP
The assumptions made about the similarity between the recorded and played
back client sessions are easy to break. Two modes have to be supported:
strict respect of recorded delays, and synchronization according to the
protocol instead of timers.
.PP
The number of available commands from is still limited (only record, replay,
stop). Command interpreter will not work well if commands are read from a 
file. It's ok if commands are read from keyboard or a pipe.
.PP
A second replay in the same session doesn't work well. It is necessary to
exit from xlab and restart.
.PP
Image capture function (for comparison between recording and replay) not
yet implemented.
.PP
GUI not yet available.
.PP
Recorded file not yet compressed.
.SH SEE ALSO
X(1), X11 and PEX Protocol documents
.SH AUTHOR
.PP
Marc Vertes 
