/*
 * $Id: fd.h,v 1.4 1998/07/24 11:59:14 marc Exp $
 *
 * header file file descriptor (FD) code 
 *
 *	James Peterson, 1987
 *	(c) Copyright MCC, 1987
 *	(c) Copyright Marc Vertes 1998
 */

#ifndef _FD_H_
#define _FD_H_

#define Boolean short
#define true 1
#define false 0

/* 
 * the following structure remembers for each file descriptor its
 * state.  In particular, we need to know if it is busy or free
 * and if it is in use, by whom.
 */

typedef int FD;

struct FDDescriptor
{
    Boolean Busy;
    int     (*InputHandler)();
};

extern struct FDDescriptor *FDD; /* array of FD descriptors */
extern short   MaxFD; /* maximum number of FD's possible */

extern short   nFDsInUse; /* number of FD's actually in use */

extern long    ReadDescriptors;/* bit map of FD's in use -- for select  */
extern short   HighestFD;	/* highest FD in use -- for select */

typedef unsigned long int TimerID;

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* fd.c */
TimerID CreateTimer P_((unsigned long int delay, void (*handler)(void), void *user_data));
void DeleteTimer P_((TimerID timer));
void InitializeFD P_((void));
void UsingFD P_((FD fd, int (*Handler)(void)));
void NotUsingFD P_((FD fd));
void EOFonFD P_((FD fd));
void MainLoop P_((void));

#undef P_

#endif /* _FD_H_ */
