/*
 * $Id: parse.l,v 1.4 1998/07/24 11:59:14 marc Exp $
 *
 * xlab command lexical analyzer
 *
 * (c) Marc Vertes 1997
 *
 */

/* option for flex only */
/* new flex version */
%option noyywrap 
/* #define yywrap()	{return 1;} 	 old flex version */

%{
#include <string.h>
#include "y.tab.h"

/* 
 * flex: redefine YY_INPUT to parse a buffer instead of standard input 
 * to do: make it portable for other lex flavors
 */
extern char *mystring;

#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) \
  { \
    int c = *mystring++; \
    result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
  }
%}

ws		[ \t]+
nl		\n
natural		[0-9]+
sysstr		![[:print:]]+\n
qstring		\"[^\"\n]*[\"\n]
filename	[A-Za-z0-9/$:.\-\_]+

%%

{ws}		;
record		{ return RECORD; }
replay		{ return REPLAY; }
stop		{ return STOP; }
set		{ return SET; }
debug		{ return DEBUG; }
trace		{ return TRACE; }
speed		{ return SPEED; }
exit		{ return EXIT; }
{sysstr}	{
                  yylval.string = (char *)strdup(yytext+1); /* skip exclamation mark (!) */
		  return SYSSTR;
		}
{qstring}	{ 
                  yylval.string = (char *)strdup(yytext+1); /* skip open quote */
		  if (yylval.string[yyleng - 2] != '"')
		    printf("Unterminated character string");
                  else
                    yylval.string[yyleng - 2] = ' '; /* remove close quote */
                  return QSTRING;
		}
{natural}	{
		  yylval.intval = atoi(yytext);
		  return NATURAL;
                }
{filename}	{
		  yylval.name = (char *)strdup(yytext);
		  return FILENAME;
		}
.		{ return yytext[0]; }

