/*
 * $Id: parse.y,v 1.4 1998/07/24 11:59:15 marc Exp $
 *
 * xlab command parser grammar
 *
 * (c) Marc Vertes 1997
 *
 */

/* Definitions section */

%{
#include <stdio.h>
#include <stdlib.h>

#include "fd.h"
#include "record.h"
#include "scope.h"

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

int yylex P_((void));
int yyerror P_((char *));

#undef P_
extern int replay_counter;
%}

%union {
	char *string;	/* quoted string (quotes removed by lex scanner) */
	char *name;	/* filename */
	int  intval;	/* integer */
}

%token EXIT
%token RECORD
%token REPLAY
%token EXTREP
%token STOP
%token SET
%token TRACE
%token DEBUG
%token SPEED
%token NL
%token <name> FILENAME
%token <string> SYSSTR
%token <string> QSTRING
%token <intval> NATURAL

%%

/* Rules section */

command:	
	  exit_command
	| set_command
	| record_command
	| replay_command
	| stop_record_command
	| stop_replay_command
	| shell_command
	;
	
set_command:
	  set_speed_command
	| set_trace_command
	| set_debug_command
	;

set_speed_command:
	SET SPEED NATURAL
	{
		printf("speed: %d\n", $3);
	}
	;

set_debug_command:
	SET DEBUG NATURAL
	{
		printf("debug: %d\n", $3);
	}
	;

set_trace_command:
	SET TRACE NATURAL
	{
		printf("trace: %d\n", $3);
	}
	;

exit_command:
	EXIT 
	{
		printf("Bye!\n");
		ReportAndExit();
	}
	;

record_command:
	RECORD FILENAME 	
	{ 
		start_record($2); 
	}
	;

replay_command:
	REPLAY FILENAME 	
        { 
		printf("Start replay\n");
		replay_counter = 1; 
		start_replay($2); 
        }
      | REPLAY FILENAME NATURAL 
        { 
		printf("Start replay\n");
		replay_counter = $3; 
		start_replay($2); 
        }
	;

stop_record_command: STOP RECORD 
	{ 
		printf("Stop record\n");
		stop_record(); 
	}
	;

stop_replay_command:
	STOP REPLAY
	{
		printf("command: stop replay\n");
	}
	;

shell_command:
	SYSSTR { printf("%s\n", $1); system($1); }
	;

/* null_command: NL {printf("> "); fflush(stdout); }; */
%%

/* user subroutines section */

int yyerror(s)
  char *s;
{
  fprintf(stderr, "%s\n", s);
  return(0);
}
