/*
 * $Id: print11.h,v 1.1 1998/07/04 11:10:23 marc Exp $
 *
 * Prototypes of printing routines implemented in print11.c
 *
 * (c) Marc Vertes 1998
 */

#ifndef _PRINT11_H_
#define _PRINT11_H_

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* print11.c */
void PrintSetUpMessage P_((unsigned char *buf));
void PrintFailedSetUpReply P_((unsigned char *buf));
void PrintSuccessfulSetUpReply P_((unsigned char *buf));
void PrintSetUpReply P_((unsigned char *buf));
void RequestError P_((unsigned char *buf));
void ValueError P_((unsigned char *buf));
void WindowError P_((unsigned char *buf));
void PixmapError P_((unsigned char *buf));
void AtomError P_((unsigned char *buf));
void CursorError P_((unsigned char *buf));
void FontError P_((unsigned char *buf));
void MatchError P_((unsigned char *buf));
void DrawableError P_((unsigned char *buf));
void AccessError P_((unsigned char *buf));
void AllocError P_((unsigned char *buf));
void ColormapError P_((unsigned char *buf));
void GContextError P_((unsigned char *buf));
void IDChoiceError P_((unsigned char *buf));
void NameError P_((unsigned char *buf));
void LengthError P_((unsigned char *buf));
void ImplementationError P_((unsigned char *buf));
void KeyPressEvent P_((unsigned char *buf));
void KeyReleaseEvent P_((unsigned char *buf));
void ButtonPressEvent P_((unsigned char *buf));
void ButtonReleaseEvent P_((unsigned char *buf));
void MotionNotifyEvent P_((unsigned char *buf));
void EnterNotifyEvent P_((unsigned char *buf));
void LeaveNotifyEvent P_((unsigned char *buf));
void FocusInEvent P_((unsigned char *buf));
void FocusOutEvent P_((unsigned char *buf));
void KeymapNotifyEvent P_((unsigned char *buf));
void ExposeEvent P_((unsigned char *buf));
void GraphicsExposureEvent P_((unsigned char *buf));
void NoExposureEvent P_((unsigned char *buf));
void VisibilityNotifyEvent P_((unsigned char *buf));
void CreateNotifyEvent P_((unsigned char *buf));
void DestroyNotifyEvent P_((unsigned char *buf));
void UnmapNotifyEvent P_((unsigned char *buf));
void MapNotifyEvent P_((unsigned char *buf));
void MapRequestEvent P_((unsigned char *buf));
void ReparentNotifyEvent P_((unsigned char *buf));
void ConfigureNotifyEvent P_((unsigned char *buf));
void ConfigureRequestEvent P_((unsigned char *buf));
void GravityNotifyEvent P_((unsigned char *buf));
void ResizeRequestEvent P_((unsigned char *buf));
void CirculateNotifyEvent P_((unsigned char *buf));
void CirculateRequestEvent P_((unsigned char *buf));
void PropertyNotifyEvent P_((unsigned char *buf));
void SelectionClearEvent P_((unsigned char *buf));
void SelectionRequestEvent P_((unsigned char *buf));
void SelectionNotifyEvent P_((unsigned char *buf));
void ColormapNotifyEvent P_((unsigned char *buf));
void ClientMessageEvent P_((unsigned char *buf));
void MappingNotifyEvent P_((unsigned char *buf));
void CreateWindow P_((unsigned char *buf));
void ChangeWindowAttributes P_((unsigned char *buf));
void GetWindowAttributes P_((unsigned char *buf));
void GetWindowAttributesReply P_((unsigned char *buf));
void DestroyWindow P_((unsigned char *buf));
void DestroySubwindows P_((unsigned char *buf));
void ChangeSaveSet P_((unsigned char *buf));
void ReparentWindow P_((unsigned char *buf));
void MapWindow P_((unsigned char *buf));
void MapSubwindows P_((unsigned char *buf));
void UnmapWindow P_((unsigned char *buf));
void UnmapSubwindows P_((unsigned char *buf));
void ConfigureWindow P_((unsigned char *buf));
void CirculateWindow P_((unsigned char *buf));
void GetGeometry P_((unsigned char *buf));
void GetGeometryReply P_((unsigned char *buf));
void QueryTree P_((unsigned char *buf));
void QueryTreeReply P_((unsigned char *buf));
void InternAtom P_((unsigned char *buf));
void InternAtomReply P_((unsigned char *buf));
void GetAtomName P_((unsigned char *buf));
void GetAtomNameReply P_((unsigned char *buf));
void ChangeProperty P_((unsigned char *buf));
void DeleteProperty P_((unsigned char *buf));
void GetProperty P_((unsigned char *buf));
void GetPropertyReply P_((unsigned char *buf));
void ListProperties P_((unsigned char *buf));
void ListPropertiesReply P_((unsigned char *buf));
void SetSelectionOwner P_((unsigned char *buf));
void GetSelectionOwner P_((unsigned char *buf));
void GetSelectionOwnerReply P_((unsigned char *buf));
void ConvertSelection P_((unsigned char *buf));
void SendEvent P_((unsigned char *buf));
void GrabPointer P_((unsigned char *buf));
void GrabPointerReply P_((unsigned char *buf));
void UngrabPointer P_((unsigned char *buf));
void GrabButton P_((unsigned char *buf));
void UngrabButton P_((unsigned char *buf));
void ChangeActivePointerGrab P_((unsigned char *buf));
void GrabKeyboard P_((unsigned char *buf));
void GrabKeyboardReply P_((unsigned char *buf));
void UngrabKeyboard P_((unsigned char *buf));
void GrabKey P_((unsigned char *buf));
void UngrabKey P_((unsigned char *buf));
void AllowEvents P_((unsigned char *buf));
void GrabServer P_((unsigned char *buf));
void UngrabServer P_((unsigned char *buf));
void QueryPointer P_((unsigned char *buf));
void QueryPointerReply P_((unsigned char *buf));
void GetMotionEvents P_((unsigned char *buf));
void GetMotionEventsReply P_((unsigned char *buf));
void TranslateCoordinates P_((unsigned char *buf));
void TranslateCoordinatesReply P_((unsigned char *buf));
void WarpPointer P_((unsigned char *buf));
void SetInputFocus P_((unsigned char *buf));
void GetInputFocus P_((unsigned char *buf));
void GetInputFocusReply P_((unsigned char *buf));
void QueryKeymap P_((unsigned char *buf));
void QueryKeymapReply P_((unsigned char *buf));
void OpenFont P_((unsigned char *buf));
void CloseFont P_((unsigned char *buf));
void QueryFont P_((unsigned char *buf));
void QueryFontReply P_((unsigned char *buf));
void QueryTextExtents P_((unsigned char *buf));
void QueryTextExtentsReply P_((unsigned char *buf));
void ListFonts P_((unsigned char *buf));
void ListFontsReply P_((unsigned char *buf));
void ListFontsWithInfo P_((unsigned char *buf));
void ListFontsWithInfoReply P_((unsigned char *buf));
void ListFontsWithInfoReply1 P_((unsigned char *buf));
void ListFontsWithInfoReply2 P_((unsigned char *buf));
void SetFontPath P_((unsigned char *buf));
void GetFontPath P_((unsigned char *buf));
void GetFontPathReply P_((unsigned char *buf));
void CreatePixmap P_((unsigned char *buf));
void FreePixmap P_((unsigned char *buf));
void CreateGC P_((unsigned char *buf));
void ChangeGC P_((unsigned char *buf));
void CopyGC P_((unsigned char *buf));
void SetDashes P_((unsigned char *buf));
void SetClipRectangles P_((unsigned char *buf));
void FreeGC P_((unsigned char *buf));
void ClearArea P_((unsigned char *buf));
void CopyArea P_((unsigned char *buf));
void CopyPlane P_((unsigned char *buf));
void PolyPoint P_((unsigned char *buf));
void PolyLine P_((unsigned char *buf));
void PolySegment P_((unsigned char *buf));
void PolyRectangle P_((unsigned char *buf));
void PolyArc P_((unsigned char *buf));
void FillPoly P_((unsigned char *buf));
void PolyFillRectangle P_((unsigned char *buf));
void PolyFillArc P_((unsigned char *buf));
void PutImage P_((unsigned char *buf));
void GetImage P_((unsigned char *buf));
void GetImageReply P_((unsigned char *buf));
void PolyText8 P_((unsigned char *buf));
void PolyText16 P_((unsigned char *buf));
void ImageText8 P_((unsigned char *buf));
void ImageText16 P_((unsigned char *buf));
void CreateColormap P_((unsigned char *buf));
void FreeColormap P_((unsigned char *buf));
void CopyColormapAndFree P_((unsigned char *buf));
void InstallColormap P_((unsigned char *buf));
void UninstallColormap P_((unsigned char *buf));
void ListInstalledColormaps P_((unsigned char *buf));
void ListInstalledColormapsReply P_((unsigned char *buf));
void AllocColor P_((unsigned char *buf));
void AllocColorReply P_((unsigned char *buf));
void AllocNamedColor P_((unsigned char *buf));
void AllocNamedColorReply P_((unsigned char *buf));
void AllocColorCells P_((unsigned char *buf));
void AllocColorCellsReply P_((unsigned char *buf));
void AllocColorPlanes P_((unsigned char *buf));
void AllocColorPlanesReply P_((unsigned char *buf));
void FreeColors P_((unsigned char *buf));
void StoreColors P_((unsigned char *buf));
void StoreNamedColor P_((unsigned char *buf));
void QueryColors P_((unsigned char *buf));
void QueryColorsReply P_((unsigned char *buf));
void LookupColor P_((unsigned char *buf));
void LookupColorReply P_((unsigned char *buf));
void CreateCursor P_((unsigned char *buf));
void CreateGlyphCursor P_((unsigned char *buf));
void FreeCursor P_((unsigned char *buf));
void RecolorCursor P_((unsigned char *buf));
void QueryBestSize P_((unsigned char *buf));
void QueryBestSizeReply P_((unsigned char *buf));
void QueryExtension P_((unsigned char *buf));
void QueryExtensionReply P_((unsigned char *buf));
void ListExtensions P_((unsigned char *buf));
void ListExtensionsReply P_((unsigned char *buf));
void ChangeKeyboardMapping P_((unsigned char *buf));
void GetKeyboardMapping P_((unsigned char *buf));
void GetKeyboardMappingReply P_((unsigned char *buf));
void ChangeKeyboardControl P_((unsigned char *buf));
void GetKeyboardControl P_((unsigned char *buf));
void GetKeyboardControlReply P_((unsigned char *buf));
void Bell P_((unsigned char *buf));
void ChangePointerControl P_((unsigned char *buf));
void GetPointerControl P_((unsigned char *buf));
void GetPointerControlReply P_((unsigned char *buf));
void SetScreenSaver P_((unsigned char *buf));
void GetScreenSaver P_((unsigned char *buf));
void GetScreenSaverReply P_((unsigned char *buf));
void ChangeHosts P_((unsigned char *buf));
void ListHosts P_((unsigned char *buf));
void ListHostsReply P_((unsigned char *buf));
void SetAccessControl P_((unsigned char *buf));
void SetCloseDownMode P_((unsigned char *buf));
void KillClient P_((unsigned char *buf));
void RotateProperties P_((unsigned char *buf));
void ForceScreenSaver P_((unsigned char *buf));
void SetPointerMapping P_((unsigned char *buf));
void SetPointerMappingReply P_((unsigned char *buf));
void GetPointerMapping P_((unsigned char *buf));
void GetPointerMappingReply P_((unsigned char *buf));
void SetModifierMapping P_((unsigned char *buf));
void SetModifierMappingReply P_((unsigned char *buf));
void GetModifierMapping P_((unsigned char *buf));
void GetModifierMappingReply P_((unsigned char *buf));
void NoOperation P_((unsigned char *buf));

#undef P_

#endif /* _PRINT_11_H_ */
