/*
 * $Id: record.h,v 1.3 1998/07/24 11:59:17 marc Exp $
 *
 * header file for recording
 *
 *	(c) Copyright 1993, Oliver Jones
 *
 */

#ifndef _RECORD_H_
#define _RECORD_H_

#include <X11/Xlib.h>
/* ********************************************** */
/*                                                */
/* ********************************************** */

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

/* path name of file to record, if any */
extern char    RecordFileName[MAXPATHLEN];

/* FILE id of file name to record, if any */
extern FILE * RecordFile;

/* path name of file to play back, if any */
extern char    PlaybackFileName[MAXPATHLEN];

/* FILE id of file name to play back, if any */
extern FILE * PlaybackFile;

/* user requested playback */
#define PLAYBACK_INACTIVE 0
#define PLAYBACK_PENDING 1
#define PLAYBACK_ACTIVE 2
#define PLAYBACK_COMPLETE 3
extern long    Playback;

/* non-zero if user requested recording  */
/* Record and Playback cannot both be nonzero */
extern long    Record ;

/* time dilation in percentage ... 200 means speed up x2 */
extern long    TimeDilation;

/* double-click time in milliseconds */
extern long    DoubleClickTime;

/* number of seconds to wait after starting program to start playback */
extern long    Wait;

/* playback error count */
extern unsigned long int Errorcount;

#ifndef MAXWTAB
#define MAXWTAB 16384
#endif

#ifndef MAXALIAS
#define MAXALIAS 16384
#endif

struct WinTab {
    unsigned long wid, parent, newid, newpar, mask;
    int depth, x, y, width, height;
    char delflag;
};

struct WinAlias {
    unsigned long wid, alias;
};

extern long maxwtab;

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* record.c */
int start_record P_((char *filename));
void stop_record P_((void));
void CloseFile P_((FILE *file));
unsigned long int Dilate P_((unsigned long int deltat));
int GetResourceBaseFd P_((XID resource));
void WaitForWindowMapped P_((int fd, XID resource, void (*handler)(void), void *user_data));
char *getstat P_((int status));
void WindowStatusAnnounce P_((FD fd, unsigned char *buf, int n, int status));
void AnnouncePlaybackError P_((Display *dpy, XErrorEvent *erev));
void SendPlaybackEvent P_((TimerID timer, int fd));
void WarpPlaybackEvent P_((Window session_window, int fd));
void TranslatePlaybackEvent P_((TimerID timer, int fd));
void end_replay P_((void));
void ReadPlaybackEvent P_((TimerID timer, int fd));
int start_replay P_((char *filename));
void RecordEvent P_((FD fd, unsigned char *buf, long n));
void RecordRequest P_((FD fd, unsigned char *buf, long n));
int MatchCreateWinRec P_((unsigned char *buf));
void LoadWtab P_((char *filename));
int OriginalWid P_((unsigned long wid));
int NewWid P_((unsigned long wid));
void SetNewParent P_((unsigned long old, unsigned long new));
void SetNewid P_((unsigned long old, unsigned long new));
unsigned long GetWinAlias P_((unsigned long wid));
void SetInferiorsNewid P_((unsigned long wid, unsigned long new));
void SetInferiorsDelflag P_((unsigned long wid, int value));
void SetDelflag P_((unsigned long wid, int value));
void dumpwtab P_((void));
void event_to_ascii P_((FD fd, unsigned char *buf, FILE *file));
int ascii_to_event_type P_((char *line));
void req_to_ascii P_((FD fd, unsigned char *buf, FILE *file));
void MatchWtab P_((FD fd, unsigned char *buf));
void ReplaceWid P_((unsigned char *buf, int offset));
int ReadSynthEvent P_((char *line));
void screen_capture P_((void));

#undef P_

#endif /* _RECORD_H_ */
