/*
 * $Id: scope.h,v 1.4 1998/07/24 11:59:18 marc Exp $
 *
 * General definitions for xlab X record/replayer
 *
 *	James Peterson, 1987
 *	(c) Copyright MCC, 1987
 *	(c) Copyright Marc Vertes 1996, 1997, 1998
 */

#ifndef _SCOPE_H_
#define _SCOPE_H_

#include <X11/Xos.h>
#include <stdio.h>

#define Boolean short
#define true 1
#define false 0

/*----------------------------------------------------------------------*/
#define Assert(b) (b)
#define debug(n,f) (void)((debuglevel & n) ? (fprintf f,fflush(stderr)) : 0)
#define enterprocedure(s)       debug(2,(stderr, "-> %s\n", s))
#define warn(s)                 fprintf(stderr, "####### %s\n", s)
#define panic(s)                {fprintf(stderr, "%s\n", s); exit(1);}

#define Free(p)		{debug(64,(stderr, "%lx = free\n", (long)p)); free(p);}

extern short   debuglevel;
extern short   Verbose;	  /* quiet (0) or increasingly verbose  ( > 0) */
extern int     ScopePort;
extern char   *ScopeHost;

/*----------------------------------------------------------------------*/
/* need to change the MaxFD to allow larger number of fd's */
/* #define StaticMaxFD 256 */
#define StaticMaxFD 4096

#include "fd.h"

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* scope.c */
short GetServerport P_((void));
short GetScopePort P_((void));
void Usage P_((char *xscript));
void ScanArgs P_((int argc, char **argv));
int main P_((int argc, char **argv));
void ReadStdin P_((FD fd));
void SetUpStdin P_((void));
void ReportAndExit P_((void));
void SetUpPair P_((FD client, FD server));
void CloseConnection P_((FD fd));
FD FDPair P_((FD fd));
FD ClientHalf P_((FD fd));
FD ServerHalf P_((FD fd));
char *ClientName P_((FD fd));
void initFDbynum P_((void));
void initwintab P_((void));
FD FDClientFromNumber P_((long clientNb));
long NumberFD P_((FD fd));
void DataFromClient P_((FD fd));
void WriteToClient P_((FD fd, unsigned char *buf, int n));
void DataFromServer P_((FD fd));
void NewConnection P_((FD fd));
FD ConnectToClient P_((FD ConnectionSocket));
FD ConnectToServer P_((int report));
char *OfficialName P_((char *name));
void DataOnXDisplay P_((FD fd));
void SetUpXDisplay P_((void));

#undef P_

#endif /* _SCOPE_H_ */
