/*
 * $Id: server.h,v 1.1 1998/07/24 11:59:19 marc Exp $
 *
 * Prototypes of functions implemented in server.c
 *
 * (c) Copyright Marc Vertes, 1998
 *
 */

#ifndef _SERVER_H_
#define _SERVER_H_

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* server.c */
void ReportFromClient P_((FD fd, unsigned char *buf, long n));
void ReportFromServer P_((FD fd, unsigned char *buf, long n));
void PrintTime P_((void));
long pad P_((long n));
unsigned long int ILong P_((unsigned char buf[]));
void OLong P_((unsigned char buf[], unsigned long int val));
unsigned short IShort P_((unsigned char buf[]));
void OShort P_((unsigned char buf[], int val));
unsigned short IChar2B P_((unsigned char buf[]));
unsigned short IByte P_((unsigned char buf[]));
void OByte P_((unsigned char buf[], int val));
short IBool P_((unsigned char buf[]));
void SaveBytes P_((FD fd, unsigned char *buf, long n));
void RemoveSavedBytes P_((FD fd, long n));
void ProcessBuffer P_((FD fd, unsigned char *buf, long n));
void StartClientConnection P_((FD fd));
void StopClientConnection P_((FD fd));
long StartSetUpMessage P_((FD fd, unsigned char *buf, long n));
long FinishSetUpMessage P_((FD fd, unsigned char *buf, long n));
long StartRequest P_((FD fd, unsigned char *buf, long n));
long FinishRequest P_((FD fd, unsigned char *buf, long n));
void StartServerConnection P_((FD fd));
void StopServerConnection P_((FD fd));
long StartSetUpReply P_((FD fd, unsigned char *buf, long n));
long FinishSetUpReply P_((FD fd, unsigned char *buf, long n));
long ErrorPacket P_((FD fd, unsigned char *buf, long n));
long EventPacket P_((FD fd, unsigned char *buf, long n));
long ReplyPacket P_((FD fd, unsigned char *buf, long n));
long ServerPacket P_((FD fd, unsigned char *buf, long n));
long FinishReply P_((FD fd, unsigned char *buf, long n));

#undef P_

#endif /* _SERVER_H_ */
