/* @(#)get_myaddress.c	2.1 88/07/29 4.0 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)get_myaddress.c 1.4 87/08/11 Copyr 1984 Sun Micro";
#endif

/*
 * get_myaddress.c
 *
 * Get client's IP address via ioctl.  This avoids using the yellowpages.
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <sys/socket.h>
#include <stdio.h>
#include <strings.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <net/if.h>

#if NLS
#include "../nls/nl_types.h"
#endif

#ifdef linux

/*
#ifndef USE_GETHOSTNAME
#define USE_GETHOSTNAME
#endif
*/

/* DO use gethostbyname because it's portable */

void get_myaddress(addr)
	struct sockaddr_in *addr;
{
#ifdef USE_GETHOSTNAME
	char localhost[256 + 1];
	struct hostent *hp;

#if NLS
	libc_nls_init();
#endif
	gethostname(localhost, 256);
	if ((hp = gethostbyname(localhost)) == NULL) {
#if NLS
		perror(catgets(_libc_cat, RpcMiscSet, RpcMiscHostname,
			       "get_myaddress: gethostbyname"));
#else
		perror("get_myaddress: gethostbyname");
#endif
		exit(1);
	}
	bcopy((char *) hp->h_addr, (char *) &addr->sin_addr, hp->h_length);
#else
	addr->sin_addr.s_addr = htonl(INADDR_LOOPBACK);
#endif
	addr->sin_family = AF_INET;
	addr->sin_port = htons(PMAPPORT);
}

#else

/* 
 * don't use gethostbyname, which would invoke yellow pages
 */
void get_myaddress(addr)
	struct sockaddr_in *addr;
{
	int s;
	char buf[BUFSIZ];
	struct ifconf ifc;
	struct ifreq ifreq, *ifr;
	int len;

#if NLS
	libc_nls_init();
#endif
	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
#if NLS
		perror(catgets(_libc_cat, RpcMiscSet, RpcMiscSocket,
			       "get_myaddress: socket"));
#else
		perror("get_myaddress: socket");
#endif
	    exit(1);
	}
	ifc.ifc_len = sizeof (buf);
	ifc.ifc_buf = buf;
	if (ioctl(s, SIOCGIFCONF, (char *)&ifc) < 0) {
#if NLS
		perror(catgets(_libc_cat, RpcMiscSet, RpcMiscIface,
			"get_myaddress: ioctl (get interface configuration)"));

#else
		perror("get_myaddress: ioctl (get interface configuration)");
#endif
		exit(1);
	}
	ifr = ifc.ifc_req;
	for (len = ifc.ifc_len; len; len -= sizeof ifreq) {
		ifreq = *ifr;
		if (ioctl(s, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
#if NLS
		perror(catgets(_libc_cat, RpcMiscSet, RpcMiscIoctl,
			"get_myaddress: ioctl"));

#else
			perror("get_myaddress: ioctl");
#endif
			exit(1);
		}
		if ((ifreq.ifr_flags & IFF_UP) &&
		    ifr->ifr_addr.sa_family == AF_INET) {
			*addr = *((struct sockaddr_in *)&ifr->ifr_addr);
			addr->sin_port = htons(PMAPPORT);
			break;
		}
		ifr++;
	}
	(void) close(s);
}
#endif
