/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
/*static char sccsid[] = "from: @(#)get_addrs.c	5.7 (Berkeley) 3/1/91";*/
static char rcsid[] = "$Id: get_addrs.c,v 1.2 1993/08/01 18:07:52 mycroft Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <protocols/talkd.h>
#include <netdb.h>
#include <stdio.h>
#include "talk_ctl.h"

/*
 * Hah.  BSD folks may have thought too simple on this one.
 * If you are a multihomed host, this program will miserably fail,
 * as it will use the IP address of "hostname" as the source of the
 * messages, not the address of the interface over which the packet
 * will be routed.
 *
 * With Linux NET-2E, a possible solution is to perform an UDP CONNECT
 * operation on a socket, so the kernel sets the correct source address
 * of the socket's packets.  Then we do a getsockname on that socket,
 * and voila... we have the correct source address!
 *
 * Note that this only works with NET-2E BETA-4 and newer kernels.
 */
get_addrs(my_machine_name, his_machine_name)
	char *my_machine_name, *his_machine_name;
{
	struct hostent *hp;
	struct servent *sp;
#ifdef __linux__
	struct sockaddr_in sin;
	struct sockaddr_in foo;
	int sock, i;

	/* If socket fails, code will see it. */
	sock = socket(AF_INET, SOCK_DGRAM, 0);
#endif

	msg.pid = htonl(getpid());
	/* look up the address of the local host */
	hp = gethostbyname(my_machine_name);
	if (hp == NULL) {
		fprintf(stderr, "talk: %s: ", my_machine_name);
		herror((char *)NULL);
		exit(-1);
	}
	bcopy(hp->h_addr, (char *)&my_machine_addr, hp->h_length);
	/*
	 * If the callee is on-machine, just copy the
	 * network address, otherwise do a lookup...
	 */
	if (strcmp(his_machine_name, my_machine_name)) {
		hp = gethostbyname(his_machine_name);
		if (hp == NULL) {
			fprintf(stderr, "talk: %s: ", his_machine_name);
			herror((char *)NULL);
			exit(-1);
		}
		bcopy(hp->h_addr, (char *) &his_machine_addr, hp->h_length);
	} else
		his_machine_addr = my_machine_addr;
	/* find the server's port */
	sp = getservbyname("ntalk", "udp");
	if (sp == 0) {
		fprintf(stderr, "talk: %s/%s: service is not registered.\n",
		     "ntalk", "udp");
		exit(-1);
	}
	daemon_port = sp->s_port;
#ifdef __linux__
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = his_machine_addr.s_addr;
	sin.sin_port = sp->s_port;

	/* Now here is the trick.  We connect to the other side. */
	if ((sock >= 0) &&
	    (connect(sock, (struct sockaddr *) &sin, sizeof(sin)) == 0)) {
		/* Bingo.  Now fetch the address. */
		foo = sin;
		i = sizeof(foo);
		if (getsockname(sock, (struct sockaddr *) &foo, &i) == 0) {
			my_machine_addr = foo.sin_addr;
		}
	}
	/* Loose the socket. */
	(void) close(sock);
#endif
}
